<?php 
include "includes/config.php"; 
$pageTitle = "Contact Us";
$pageDescription = "Get in touch with " . SITE_NAME . " - we'd love to hear from you";
include 'includes/header.php'; 

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone']);
    $subject = trim($_POST['subject']);
    $message = trim($_POST['message']);
    
    $errors = [];
    
    // Validate inputs
    if (empty($name)) {
        $errors[] = 'Name is required';
    }
    
    if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = 'Valid email is required';
    }
    
    if (empty($message)) {
        $errors[] = 'Message is required';
    }
    
    if (empty($errors)) {
        // Process the form (send email, save to database, etc.)
        $to = SITE_EMAIL;
        $headers = "From: $email\r\n";
        $headers .= "Reply-To: $email\r\n";
        $email_subject = "New Contact Form Submission: $subject";
        $email_body = "You have received a new message from $name.\n\n".
                      "Email: $email\n".
                      "Phone: $phone\n\n".
                      "Message:\n$message";
        
        // Send email
        if (mail($to, $email_subject, $email_body, $headers)) {
            $success = "Thank you for your message! We'll get back to you soon.";
            // Clear form fields
            $name = $email = $phone = $subject = $message = '';
        } else {
            $errors[] = 'There was a problem sending your message. Please try again.';
        }
    }
}
?>

    <section class="page-header">
        <h1>Contact Us</h1>
        <p>We'd love to hear from you</p>
    </section>
    
    <section class="contact-section">
        <div class="contact-info">
            <h2>Get In Touch</h2>
            <p>Have questions or want to discuss your project? Reach out to us using the information below or fill out the contact form.</p>
            
            <div class="contact-method">
                <i class="fas fa-map-marker-alt"></i>
                <h3>Address</h3>
                <p><?php echo SITE_ADDRESS; ?></p>
            </div>
            
            <div class="contact-method">
                <i class="fas fa-phone"></i>
                <h3>Phone</h3>
                <p><?php echo SITE_PHONE; ?></p>
            </div>
            
            <div class="contact-method">
                <i class="fas fa-envelope"></i>
                <h3>Email</h3>
                <p><?php echo SITE_EMAIL; ?></p>
            </div>
            
            <div class="business-hours">
                <h3>Business Hours</h3>
                <p>Monday - Friday: 9:00 AM - 5:00 PM</p>
                <p>Saturday: 10:00 AM - 2:00 PM</p>
                <p>Sunday: Closed</p>
            </div>
        </div>
        
        <div class="contact-form">
            <h2>Send Us a Message</h2>
            
            <?php if (!empty($errors)): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php foreach ($errors as $error): ?>
                            <li><?php echo $error; ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>
            
            <?php if (isset($success)): ?>
                <div class="alert alert-success">
                    <?php echo $success; ?>
                </div>
            <?php endif; ?>
            
            <form action="contact.php" method="post">
                <div class="form-group">
                    <label for="name">Your Name*</label>
                    <input type="text" id="name" name="name" value="<?php echo isset($name) ? htmlspecialchars($name) : ''; ?>" required>
                </div>
                
                <div class="form-group">
                    <label for="email">Your Email*</label>
                    <input type="email" id="email" name="email" value="<?php echo isset($email) ? htmlspecialchars($email) : ''; ?>" required>
                </div>
                
                <div class="form-group">
                    <label for="phone">Phone Number</label>
                    <input type="tel" id="phone" name="phone" value="<?php echo isset($phone) ? htmlspecialchars($phone) : ''; ?>">
                </div>
                
                <div class="form-group">
                    <label for="subject">Subject</label>
                    <input type="text" id="subject" name="subject" value="<?php echo isset($subject) ? htmlspecialchars($subject) : ''; ?>">
                </div>
                
                <div class="form-group">
                    <label for="message">Your Message*</label>
                    <textarea id="message" name="message" rows="5" required><?php echo isset($message) ? htmlspecialchars($message) : ''; ?></textarea>
                </div>
                
                <button type="submit" class="btn btn-primary">Send Message</button>
            </form>
        </div>
    </section>
    
    <section class="map-section">
        <h2>Our Location</h2>
        <div class="map-container">
            <!-- Replace with your actual Google Maps embed code -->
            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3022.215573291234!2d-73.9878449241646!3d40.74844097138978!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89c259a9b3117469%3A0xd134e199a405a163!2sEmpire%20State%20Building!5e0!3m2!1sen!2sus!4v1629999999999!5m2!1sen!2sus" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
        </div>
    </section>

<?php include 'includes/footer.php'; ?>